% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{cluster_SN_markers}
\alias{cluster_SN_markers}
\title{Cluster 1.0 markers}
\usage{
cluster_SN_markers(
  linkage_df,
  LOD_sequence = 7,
  independence_LOD = FALSE,
  LG_number,
  ploidy,
  parentname = "",
  plot_network = F,
  min_clust_size = 1,
  plot_clust_size = TRUE,
  max_vertex_size = 5,
  min_vertex_size = 2,
  phase_considered = "All",
  log = NULL
)
}
\arguments{
\item{linkage_df}{A linkage data.frame as output of \code{\link{linkage}} calculating linkage between 1.0 markers.}

\item{LOD_sequence}{A numeric vector. Specifying a sequence of LOD thresholds at which clustering is performed.}

\item{independence_LOD}{Logical. Should the LOD of independence be used for clustering? (by default, \code{FALSE}.)}

\item{LG_number}{Expected number of chromosomes (linkage groups)}

\item{ploidy}{Ploidy level of the plant species}

\item{parentname}{Name of parent}

\item{plot_network}{Logical. Should a network be plotted. Recommended FALSE with large number of marker combinations.}

\item{min_clust_size}{Integer. The minimum cluster size to be plotted. This does not delete clusters. All clusters are returned.}

\item{plot_clust_size}{Logical. Should exact cluster size be plotted as vertex labels?}

\item{max_vertex_size}{Integer. The maximum vertex size. Only used if \code{plot_clust_size=FALSE}.}

\item{min_vertex_size}{Integer. The minimum vertex size. Only used if \code{plot_clust_size=FALSE}.}

\item{phase_considered}{Character string. By default all phases are used, but "coupling" or "repulsion" are also allowed.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout (console).}
}
\value{
A list with cluster data.frames.
}
\description{
\code{cluster_SN_markers} clusters simplex nulliplex at different LOD scores.
}
\examples{
data("SN_SN_P1")
cluster_list<-cluster_SN_markers(SN_SN_P1,LOD_sequence=c(4:10),parentname="P1",ploidy=4,LG_number=5)
}
