% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{check_cofactors}
\alias{check_cofactors}
\title{Build a multi-QTL model using step-wise procedure of checking genetic co-factors.}
\usage{
check_cofactors(
  IBD_list,
  Phenotype.df,
  genotype.ID,
  trait.ID,
  LOD_data,
  min_res = 20,
  ncores = 1,
  verbose = TRUE
)
}
\arguments{
\item{IBD_list}{List of IBD_probabilities as estimated using one of the various methods available (e.g. \code{\link{estimate_IBD}}).}

\item{Phenotype.df}{A data.frame containing phenotypic values}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the population identifiers (F1 names) (must be a colname of \code{Phenotype.df})}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model (must be a colname of \code{Phenotype.df})}

\item{LOD_data}{Output of \code{\link{QTLscan}} function.}

\item{min_res}{The minimum genetic distance (resolution) assumed possible to consider 2 linked QTL (on the same linkage group) as independent. By default a value of 20 cM is used.
This is not to suggest that 20 cM is a realistic resolution in a practical mapping study, but it provides the function with a criterion to consider 2 significant QTL within this distance as one and the same. 
For this purpose, 20 cM seems a reasonable value to use. In practice, closely linked QTL will generally "explain" all the variation at nearby positions, making it unlikely to
be able to disentangle their effects. QTL positions will vary slightly when co-factors are introduced, but again this variation is presumed not to exceed 20 cM either side.}

\item{ncores}{How many CPU cores should be used in the evaluation? By default 1 core is used.}

\item{verbose}{Logical, by default \code{TRUE} - should progress messages be printed to the console?}
}
\value{
Data frame with the following columns:
\itemize{
\item{LG: }{ Linkage group identifier}
\item{cM: }{ CentiMorgan position}
\item{deltaLOD: }{ The difference between the LOD score at the peak and the significance threshold (always positive, otherwise the QTL would not be significant)}
\item{CofactorID: }{ A identifier giving the co-factor model used in detecting the QTL (if no co-factors were included then \code{NA}). The co-factor model is described
by concatenating all co-factor positions with a '+', so for example 1_10+4_20 would mean a co-factor model with 2 positions included as co-factors, namely 10 cM on linkage
group 1 and 20 cM on linkage group 4.}
}
}
\description{
The function \code{check_cofactors} initially fits all significant QTL positions as co-factors, both individually and in combination. Significance thresholds
are re-estimated each time, yielding threshold-corrected LOD scores. If this leads to a change in the estimated position of QTL, or detection of subsequent peaks, a second 
round of co-factor inclusion is performed for all new QTL or novel QTL combinations. Finally, the multi-QTL model that maximises the individual significance of each
QTL is returned as a data.frame. This can be directly passed to the function \code{\link{PVE}} to estimate the percentage variance explained by the full
multi-QTL model and all possible sub-models. 
Note: this function estimates the most likely QTL positions by maximising the threshold-corrected LOD at QTL peaks.
Non-additive interactions between QTL may be missed as a result. It is recommended to run a manual co-factor analysis as well,
as described in the package vignette.
}
\examples{
data("IBD_4x","BLUEs.pheno","qtl_LODs.4x")
check_cofactors(IBD_list=IBD_4x,Phenotype.df=BLUEs.pheno,
genotype.ID="Geno",trait.ID="BLUE",LOD_data=qtl_LODs.4x)
}
