% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_function.R
\name{value_function}
\alias{value_function}
\alias{plot_value_function}
\title{Value Function}
\usage{
value_function(model, drop = TRUE)

plot_value_function(
  model,
  projection = NULL,
  epoch = 1,
  ylim = NULL,
  legend = TRUE,
  col = NULL,
  lwd = 1,
  lty = 1,
  ylab = "Value",
  ...
)
}
\arguments{
\item{model}{a solved \link{POMDP} or \link{MDP}.}

\item{drop}{logical; drop the list for converged converged, epoch-independent value functions.}

\item{projection}{Sample in a projected belief space. See \code{\link[=projection]{projection()}} for details.}

\item{epoch}{the value function of what epoch should be plotted? Use 1 for
converged policies.}

\item{ylim}{the y limits of the plot.}

\item{legend}{logical; show the actions in the visualization?}

\item{col}{potting colors.}

\item{lwd}{line width.}

\item{lty}{line type.}

\item{ylab}{label for the y-axis.}

\item{...}{additional arguments are passed on to \code{\link[stats:line]{stats::line()}}
or \code{\link[graphics:barplot]{graphics::barplot()}}`.}
}
\value{
the function as a matrix with alpha vectors as rows.
}
\description{
Extracts the value function from a solved model.
Extracts the alpha vectors describing the value function. This is similar to \code{\link[=policy]{policy()}} which in addition returns the
action prescribed by the solution.
}
\details{
Plots the value function of a POMDP solution as a line plot. The solution is
projected on two states (i.e., the belief for the other states is held
constant at zero). The value function can also be visualized using \code{\link[=plot_belief_space]{plot_belief_space()}}.
}
\examples{
data("Tiger")
sol <- solve_POMDP(Tiger)
sol

# value function for the converged solution
value_function(sol)

plot_value_function(sol, ylim = c(0,20))

## finite-horizon problem
sol <- solve_POMDP(model = Tiger, horizon = 3, discount = 1,
  method = "enum")
sol

# inspect the value function for all epochs
value_function(sol)

plot_value_function(sol, epoch = 1, ylim = c(-5, 25))
plot_value_function(sol, epoch = 2, ylim = c(-5, 25))
plot_value_function(sol, epoch = 3, ylim = c(-5, 25))

\dontrun{
# using ggplot2 to plot the value function for epoch 3
library(ggplot2)
pol <- policy(sol)
ggplot(pol[[3]]) +
 geom_segment(aes(x = 0, y = `tiger-left`, xend = 1, yend = `tiger-right`, color = action)) +
 coord_cartesian(ylim = c(-5, 15)) + ylab("Value") + xlab("Belief space")
}
}
\seealso{
Other policy: 
\code{\link{estimate_belief_for_nodes}()},
\code{\link{optimal_action}()},
\code{\link{plot_belief_space}()},
\code{\link{plot_policy_graph}()},
\code{\link{policy}()},
\code{\link{policy_graph}()},
\code{\link{projection}()},
\code{\link{reward}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()}

Other POMDP: 
\code{\link{MDP2POMDP}},
\code{\link{POMDP}()},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{write_POMDP}()}

Other MDP: 
\code{\link{MDP}()},
\code{\link{MDP2POMDP}},
\code{\link{MDP_policy_functions}},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{gridworld}},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{simulate_MDP}()},
\code{\link{solve_MDP}()},
\code{\link{transition_graph}()}
}
\author{
Michael Hahsler
}
\concept{MDP}
\concept{POMDP}
\concept{policy}
\keyword{hplot}
