% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_write}
\alias{read_write}
\alias{read_alpha_file}
\alias{read_pg_file}
\alias{read_belief_file}
\alias{write_grid_file}
\alias{write_terminal_values}
\title{Read and Write Files for 'pomdp-solve'}
\usage{
read_alpha_file(file)

read_pg_file(file)

read_belief_file(file)

write_grid_file(file, belief_points, digits = 7)

write_terminal_values(file, alpha, digits = 7)
}
\arguments{
\item{file}{name of the file to read from or to write to.}

\item{belief_points}{a numeric matrix with the number of states columns. Rows represent belief points.}

\item{digits}{number of digits used to write files.}

\item{alpha}{a numeric alpha vector with the length of the number of states.}
}
\value{
\itemize{
\item \code{read_alpha_file()} returns the value function (alpha vectors) as a matrix.
\item \code{read_pg_file()} returns the policy graph as a data.frame.
\item \code{read_belief_file()} returns a matrix if the solver wrote a belief file.
\item \code{write_grid_file()} returns nothing.
\item \code{write_terminal_values()} returns nothing.
}
}
\description{
Read and write files for the pomdp-solve executable.
}
\details{
pomdp-solve uses text format for its input and output. The input is a \href{https://www.pomdp.org/code/pomdp-file-spec.html}{POMDP file}. The outputs are the following.

\strong{Value Function}

The value function is returned as files with the extension \code{.alpha}
in the format:

\preformatted{
A
V1 V2 V3 ... VN

A
V1 V2 V3 ... VN

...
}

Where \code{A} is an action number and the \code{V1} through \code{VN} are real values
representing the components of a particular vector that has the
associated action. The action number is the 0-based index of
the action as specified in
the input POMDP file. The vector represents the coefficients of a hyperplane
representing one facet of the piecewise linear and convex (PWLC) value
function. Note that the length of the lists needs to be equal to the
number of states in the POMDP.

\code{read_alpha_file()} reads the V components from the file and returns a matrix.

\strong{Policy Graph}

The policy graph is returned as a file with the extension \code{.pg}.
Each line of the file represents one node of the policy graph and
its contents are:

\preformatted{
N A  Z1 Z2 Z3 ...
...
}

Here \code{N} is a node ID giving the node a unique name, numbered sequentially
and lining up with the value function vectors in the
corresponding output \code{.alpha} file above.

The \code{A} is the action number defined for this node; it is an integer referring
to the the POMDP file actions by its 0-based index number.
These are followed by a list of node IDs, one for each observation. Thus the
list will have a length equal to the number of observations in the POMDP.
This list specifies the transitions in the policy graph. The nth number in
the list will be the index of the node that follows this one when the
observation received is \code{n}.

\code{read_pg_file()} returns a data.frame with the nodes in the policy graph as rows.

\strong{Terminal Values}

Terminal values can be specified as a single alpha vector.

\strong{Grid-based Solver Specific Files}

The grid-based method can write the used belief points do disk (command line option \code{-fg_save}). The
file can be read using \code{read_belief_file()}.

A matrix with belief points can be written using \code{write_grid_file()}. This file can be used

Details about the file formats and pomdp-solve can be found in the References section.

See \code{\link[=pomdp_solve]{pomdp_solve()}} for examples.
}
\references{
Anthony R. Cassandra, pomdp-solve documentation,
\url{https://www.pomdp.org/code/index.html}
}
\seealso{
find_pomdp_solve
}
