% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariate_table.R
\name{covariates}
\alias{covariates}
\alias{covariate_table}
\alias{covariate_table,missing-method}
\alias{covariate_table,ANY-method}
\alias{covariate_table,numeric-method}
\alias{covariate_table,character-method}
\title{Covariates}
\usage{
\S4method{covariate_table}{numeric}(..., order = c("linear", "constant"), times)

\S4method{covariate_table}{character}(..., order = c("linear", "constant"), times)
}
\arguments{
\item{\dots}{numeric vectors or data frames containing time-varying covariates.
It must be possible to bind these into a data frame.}

\item{order}{the order of interpolation to be used.
Options are \dQuote{linear} (the default) and \dQuote{constant}.
Setting \code{order="linear"} treats the covariates as piecewise linear functions of time;
\code{order="constant"} treats them as right-continuous piecewise constant functions.}

\item{times}{the times corresponding to the covariates.
This may be given as a vector of (non-decreasing, finite) numerical values.
Alternatively, one can specify by name which of the given variables is the time variable.}
}
\description{
Incorporating time-varying covariates using lookup tables.
}
\details{
If the \sQuote{pomp} object contains covariates (specified via the \code{covar} argument), then interpolated values of the covariates will be available to each of the model components whenever it is called.
In particular, variables with names as they appear in the \code{covar} covariate table will be available to any C snippet.
When a basic component is defined using an \R function, that function will be called with an extra argument, \code{covars}, which will be a named numeric vector containing the interpolated values from the covariate table.

An exception to this rule is the prior (\code{rprior} and \code{dprior}):
covariate-dependent priors are not allowed.
Nor are parameter transformations permitted to depend upon covariates.
}
\seealso{
More on implementing POMP models: 
\code{\link{Csnippet}},
\code{\link{accumulator variables}},
\code{\link{basic components}},
\code{\link{distributions}},
\code{\link{dmeasure specification}},
\code{\link{dprocess specification}},
\code{\link{parameter transformations}},
\code{\link{pomp-package}},
\code{\link{pomp}},
\code{\link{prior specification}},
\code{\link{rinit specification}},
\code{\link{rmeasure specification}},
\code{\link{rprocess specification}},
\code{\link{skeleton specification}},
\code{\link{transformations}},
\code{\link{userdata}}

More on interpolation:
\code{\link{bsplines}},
\code{\link{lookup}()}
}
\concept{covariates}
\concept{implementation information}
\concept{interpolation}
