% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmeasure_spec.R
\name{vmeasure specification}
\alias{vmeasure specification}
\title{The variance of the measurement model}
\description{
Specification of the measurement-model covariance  matrix, vmeasure.
}
\details{
The measurement model is the link between the data and the unobserved state process.
Some algorithms require the conditional covariance of the measurement model, given the latent state and parameters.
This is supplied using the \code{vmeasure} argument.

Suppose you have a procedure to compute this conditional covariance matrix, given the value of the latent state variables.
Then you can furnish \preformatted{
  vmeasure = f}
to \pkg{pomp} algorithms,
where \code{f} is a C snippet or \R function that implements your procedure.

Using a C snippet is much preferred, due to its much greater computational efficiency.
See \code{\link{Csnippet}} for general rules on writing C snippets.

In writing a \code{vmeasure} C snippet, bear in mind that:
  \enumerate{
    \item The goal of such a snippet is to fill variables named \code{V_y_z} with the conditional covariances of observables \code{y}, \code{z}.
    Accordingly, there should be one assignment of \code{V_y_z} and one assignment of \code{V_z_y} for each pair of observables \code{y} and \code{z}.
    \item In addition to the states, parameters, and covariates (if any), the variable \code{t}, containing the time of the observation, will be defined in the context in which the snippet is executed.
  }

The demos and the tutorials on the \href{https://kingaa.github.io/pomp/}{package website} give examples.

It is also possible, though less efficient, to specify \code{vmeasure} using an \R function.
In this case, specify it by furnishing \preformatted{
  vmeasure = f}
to \code{pomp}, where \code{f} is an \R function.
The arguments of \code{f} should be chosen from among the state variables, parameters, covariates, and time.
It must also have the argument \code{...}.
\code{f} must return a square matrix of dimension equal to the number of observable variables.
The row- and column-names of this matrix should match the names of the observable variables.
The matrix should of course be symmetric.
}
\section{Default behavior}{

The default \code{vmeasure} is undefined.
It will yield missing values (\code{NA}).
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\seealso{
\code{\link{vmeasure}}

More on implementing POMP models: 
\code{\link{Csnippet}},
\code{\link{accumulator variables}},
\code{\link{basic components}},
\code{\link{betabinomial}},
\code{\link{covariates}},
\code{\link{distributions}},
\code{\link{dmeasure specification}},
\code{\link{dprocess specification}},
\code{\link{emeasure specification}},
\code{\link{parameter transformations}},
\code{\link{pomp-package}},
\code{\link{pomp}},
\code{\link{prior specification}},
\code{\link{rinit specification}},
\code{\link{rmeasure specification}},
\code{\link{rprocess specification}},
\code{\link{skeleton specification}},
\code{\link{transformations}},
\code{\link{userdata}}
}
\concept{implementation information}
