% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_pool.R
\name{popReads}
\alias{popReads}
\title{Compute number of reads for each individual and across all sites}
\usage{
popReads(vector_np, coverage, pError)
}
\arguments{
\item{vector_np}{is a vector where each entry contains the number of diploid
individuals of a given pool. Thus, if a population was sequenced using two
pools, each with 10 individuals, this vector would contain two entries and
both will be 10.}

\item{coverage}{a vector containing the total depth of coverage of the
population. Each entry of the vector represents a different site.}

\item{pError}{an integer representing the value of the error associated with
DNA pooling. This value is related with the unequal contribution of both
individuals and pools towards the total number of reads observed for a
given population - the higher the value the more unequal are the individual
and pool contributions.}
}
\value{
a matrix with the number of reads contributed by each individual.
Each row of the matrix corresponds to a different individual and each
column to a different site.
}
\description{
This function computes the contribution of each individual towards the total
coverage of a given population.
}
\details{
If multiple pools were used to sequence a population, this will compute the
contribution of each pool and then use that to calculate how many reads does
that pool contribute. Next, the probability of contribution of each
individual is computed and utilized to calculate the number of reads that
each individual contributes towards the total number of reads observed in the
corresponding pool.
}
\examples{
# simulate number of reads contributed by each individual towards the total population coverage
# assuming a coverage of 10x at 5 sites and two pools, each with 5 individuals
popReads(vector_np = c(5, 5), coverage = rep(10, 5), pError = 100)

}
