% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pop_Gen_Functions.R
\name{JostD}
\alias{JostD}
\title{Calculate Jost's D}
\usage{
JostD(J = matrix, pairwise = TRUE)
}
\arguments{
\item{J}{A gene identity matrix.}

\item{pairwise}{Logical indicating whether to calculate pairwise Jost's D.
If pairwise=FALSE, must not have any missing data.}
}
\value{
If pairwise = TRUE, returns a matrix of pairwise Jost's D values.
If pairwise = FALSE, returns the overall Jost's D value.
}
\description{
This function calculates Jost's D measure from a gene identity matrix.
}
\examples{
gene_identity_matrix <- matrix(c(
0.3164550, 0.2836333, 0.2760485,
0.2836333, 0.3106084, 0.2867215,
0.2760485, 0.2867215, 0.3338663
), nrow = 3, byrow = TRUE,
dimnames = list(paste0("Sample", 1:3), paste0("Sample", 1:3)))

JostD(J=gene_identity_matrix, pairwise=TRUE)
JostD(J=gene_identity_matrix, pairwise=FALSE)
}
