% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fstats.R
\name{plot_fstats}
\alias{plot_fstats}
\title{Plot F2, F3, F3star, F4, D or pairwise Fst values with their Confidence Intervals}
\usage{
plot_fstats(
  x,
  stat.name = "F2",
  ci.perc = 95,
  value.range = c(NA, NA),
  pop.sel = NA,
  pop.f3.target = NA,
  highlight.signif = TRUE,
  main = stat.name,
  ...
)
}
\arguments{
\item{x}{An object of class fstats (to plot heterozygosities, divergence, F2, F3, F3star, F4 or D statistics) or pairwisefst (to plot pairwise fst)}

\item{stat.name}{For fstats object, the name of the stat (either heterozygosities, divergence, F2, F3, F3star, F4 or Dstat)}

\item{ci.perc}{Percentage of the Confidence Interval in number of standard errors (default=95\%)}

\item{value.range}{Range of test values (x-axis) to be plotted (default=NA,NA: i.e., all test values are plotted)}

\item{pop.sel}{Only plot test values involving these populations (default=NA: i.e., all test values are plotted)}

\item{pop.f3.target}{For F3-statistics, only plot F3 involving pop.f3.target as a target}

\item{highlight.signif}{If TRUE highlight significant tests in red (see details)}

\item{main}{Main title of the plot (default=stat.name)}

\item{...}{Some other graphical arguments to be passed}
}
\value{
A plot of the Fstats of interest. Significant F3 statistics (i.e., showing formal evidence for admixture of the target population) are highlighted in red. Significant F4 statistics (i.e., showing formal evidence against treeness of the pop. quadruplet) are highlighted in red.
}
\description{
Plot F2, F3, F3star, F4, D or pairwise Fst values with their Confidence Intervals
}
\details{
Data will only be plotted if jackknife estimates of the estimator s.e. have been performed i.e. if the functions compute.fstats or compute.pairwiseFST were run with nsnp.per.block>0
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),
                   poolsizes=rep(50,15),poolnames=paste0("P",1:15))
 res.fstats=compute.fstats(pooldata,nsnp.per.bjack.block=25)
 plot_fstats(res.fstats,stat.name="F3",cex=0.5)
 plot_fstats(res.fstats,stat.name="F3",value.range=c(NA,0.001),
             pop.f3.target=c("P7","P5"),cex.axis=0.7)
 plot_fstats(res.fstats,stat.name="F4",cex=0.5) 
 #allow to reduce the size of the test name (y-axis)
 plot_fstats(res.fstats,stat.name="F4",cex=0.5,
             pop.sel=c("P1","P2","P3","P4","P5")) 
 plot_fstats(res.fstats,stat.name="F4",cex=0.5,
             pop.sel=c("P1","P2","P3","P4","P5"),highlight.signif=FALSE)  
}
\seealso{
To generate x object, see \code{\link{compute.pairwiseFST}} (for pairwisefst object) or \code{\link{compute.fstats}}  (for fstats object)
}
