% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomallele.pca.R
\name{randomallele.pca}
\alias{randomallele.pca}
\title{PCA of a pooldata or countdata object using a random allele approach}
\usage{
randomallele.pca(
  x,
  scale = TRUE,
  return.snploadings = FALSE,
  plot.pcs = c(1, 2),
  ...
)
}
\arguments{
\item{x}{A pooldata object containing Pool-Seq information or a countdata object containing allele count information}

\item{scale}{If FALSE the random allele data matrix is not scaled (default=TRUE)}

\item{return.snploadings}{If TRUE return the SNP loadings (may be large)}

\item{plot.pcs}{A vector with two-elements giving the two PCs to plot. If NULL, no plotting is done.}

\item{...}{graphical parameters (see \code{\link{plot}} function)}
}
\value{
An object of class fstats (see help(fstats) for details)
}
\description{
PCA of a pooldata or countdata object using a random allele approach
}
\details{
PCA is performed by singular-value decomposition (SVD) of a npop (or npools) x nsnp matrix of a single randomly sampled allele (i.e. or read for pooldata object) for each SNP and for each population (inspired by Skoglund and Jakobsson, 2011, https://doi.org/10.1073/pnas.1108181108). Although this approach leads to information loss, it allows to efficiently account for unequal sample size (and read coverages for pool-seq data) and have little impact on the resulting representation when the number of SNPs is large. Note also that the implemented approach is similar to that implemented in the PCA_MDS module of the software ANGSD by Korneliussen et al. (2014) (see http://www.popgen.dk/angsd/index.php/PCA_MDS).
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata<-popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 res.pca<-randomallele.pca(pooldata)
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}},\code{\link{genobaypass2pooldata}} or \code{\link{genoselestim2pooldata}}. To generate coundata object, see \code{\link{genobaypass2countdata}} or \code{\link{genotreemix2countdata}}.
}
