% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-funs.R
\name{plot_trend}
\alias{plot_trend}
\title{Plot estimated population trend}
\usage{
plot_trend(series, title = TRUE, path = ".", path_fig = ".", save = FALSE)
}
\arguments{
\item{series}{a \code{character} string. The count series name (can be
retrieved by running \code{\link[=list_series]{list_series()}}).}

\item{title}{a \code{logical}. If \code{TRUE} (default) a title (series name) is
added.}

\item{path}{a \code{character} string. The directory in which count series (and
BUGS outputs) have been saved by the function \code{\link[=format_data]{format_data()}} (and by
\code{\link[=fit_trend]{fit_trend()}}).}

\item{path_fig}{a \code{character} string. The directory where to save the plot
(if \code{save = TRUE}). This directory must exist and can be an absolute or a
relative path.}

\item{save}{a \code{logical}. If \code{TRUE} (default is \code{FALSE}) the plot is saved in
\code{path_fig}.}
}
\value{
No return value.
}
\description{
This function plots a panel of two graphics for one BUGS model
(previously generated by \code{\link[=fit_trend]{fit_trend()}}):
\itemize{
\item on the left side, the population trend estimated by the Bayesian model
(blue line) with the 95\% CI (gray envelop). Dots (with intervals)
represent converted counts passed to the model (with the 95\% CI);
\item on the right side, a bar plot of estimated relative growth rates (r) by
date. Dark bars are real estimated r.
}
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(garamba, path = temp_path)

## Select one serie ----
a_buselaphus <- popbayes::filter_series(garamba_formatted, 
                                        location = "Garamba",
                                        species  = "Alcelaphus buselaphus")
\donttest{
## Fit population trends (requires JAGS) ----
a_buselaphus_mod <- popbayes::fit_trend(a_buselaphus, path = temp_path)

## Plot estimated population trend ----
popbayes::plot_trend(series = "garamba__alcelaphus_buselaphus", 
                     path   = temp_path)
}
}
