% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_subset.r
\name{clonecorrect}
\alias{clonecorrect}
\title{Remove potential bias caused by cloned genotypes in genind or genclone 
object.}
\usage{
clonecorrect(pop, strata = 1, combine = FALSE, keep = 1)
}
\arguments{
\item{pop}{a \code{\link{genind}} object}

\item{strata}{a hierarchical formula or numeric vector. This will define the columns of the 
data frame in the strata slot to use.}

\item{combine}{\code{logical}. When set to TRUE, the strata will be 
combined to create a new population for the clone-corrected genind or 
genclone object.}

\item{keep}{\code{integer}. When \code{combine} is set to \code{FALSE}, you 
can use this flag to choose the levels of your population strata. For 
example: if your clone correction strata is set to "Pop", "Subpop", and 
"Year", and you want to analyze your populations with respect to year, you 
can set \code{keep = c(1,3)}.}
}
\value{
a clone corrected \code{\linkS4class{genclone}} or
  \code{\linkS4class{genind}} object.
}
\description{
This function removes any duplicated multilocus genotypes from any specified 
population strata.
}
\details{
This function will clone correct based on the stratification 
  provided. To clone correct indiscriminately of population structure, set 
  \code{strata = NA}.
}
\examples{
# LOAD A. euteiches data set
data(Aeut)

# Redefine it as a genclone object
Aeut <- as.genclone(Aeut)
strata(Aeut) <- other(Aeut)$population_hierarchy[-1]

# Check the number of multilocus genotypes
mlg(Aeut)
popNames(Aeut)

# Clone correct at the population level.
Aeut.pop <- clonecorrect(Aeut, strata =  ~Pop)
mlg(Aeut.pop)
popNames(Aeut.pop)

\dontrun{
# Clone correct at the subpopulation level with respect to population and
# combine.
Aeut.subpop <- clonecorrect(Aeut, strata = ~Pop/Subpop, combine=TRUE)
mlg(Aeut.subpop)
popNames(Aeut.subpop)

# Do the same, but set to the population level.
Aeut.subpop2 <- clonecorrect(Aeut, strata = ~Pop/Subpop, keep=1)
mlg(Aeut.subpop2)
popNames(Aeut.subpop2)

# LOAD H3N2 dataset
data(H3N2)

strata(H3N2) <- other(H3N2)$x

# Extract only the individuals located in China
country <- clonecorrect(H3N2, strata =  ~country)

# How many isolates did we have from China before clone correction?
sum(strata(H3N2, ~country) == "China") # 155

# How many unique isolates from China after clone correction?
sum(strata(country, ~country) == "China") # 79

# Something a little more complicated. (This could take a few minutes on
# slower computers)

# setting the hierarchy to be Country > Year > Month  
c.y.m <- clonecorrect(H3N2, strata =  ~year/month/country)

# How many isolates in the original data set?
nInd(H3N2) # 1903

# How many after we clone corrected for country, year, and month?
nInd(c.y.m) # 1190
}
}
\author{
Zhian N. Kamvar
}

