% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\docType{methods}
\name{mll.custom}
\alias{mll.custom}
\alias{mll.custom,genclone-method}
\alias{mll.custom,snpclone-method}
\alias{mll.custom<-}
\alias{mll.custom<-,genclone-method}
\alias{mll.custom<-,snpclone-method}
\alias{mll.levels}
\alias{mll.levels,genclone-method}
\alias{mll.levels,snpclone-method}
\alias{mll.levels<-}
\alias{mll.levels<-,genclone-method}
\alias{mll.levels<-,snpclone-method}
\title{Define custom multilocus lineages}
\usage{
mll.custom(x, set = TRUE, value)

mll.custom(x, set = TRUE) <- value

mll.levels(x, set = TRUE, value)

mll.levels(x, set = TRUE) <- value
}
\arguments{
\item{x}{a \linkS4class{genclone} or \linkS4class{snpclone} object.}

\item{set}{logical. If \code{TRUE} (default), the visible mlls will be set to
'custom'.}

\item{value}{a vector that defines the multilocus lineages for your data.
This can be a vector of ANYTHING that can be turned into a factor.}
}
\value{
an object of the same type as x
}
\description{
This function will allow you to define custom multilocus lineages for your
data set.
}
\examples{
data(partial_clone)
pc <- as.genclone(partial_clone)
mll.custom(pc) <- LETTERS[mll(pc)]
mll(pc)

# Let's say we had a mistake and the A mlg was actually B. 
mll.levels(pc)[mll.levels(pc) == "A"] <- "B"
mll(pc)

# Set the MLL back to the original definition.
mll(pc) <- "original"
mll(pc)
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link{mll}} \code{\link{mlg.table}}
}

