% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.r
\name{genotype_curve}
\alias{genotype_curve}
\title{Produce a genotype accumulation curve}
\usage{
genotype_curve(gen, sample = 100, maxloci = 0L, quiet = FALSE,
  thresh = 1)
}
\arguments{
\item{gen}{a \code{\linkS4class{genclone}} or \code{\linkS4class{genind}} 
object.}

\item{sample}{an \code{integer} defining the number of times loci will be 
resampled without replacement.}

\item{maxloci}{the maximum number of loci to sample. By default,
\code{maxloci = 0}, which indicates that n - 1 loci are to be used. Note that this will always take min(n - 1, maxloci)}

\item{quiet}{if \code{FALSE} (default), Progress of the iterations will be 
displayed. If \code{TRUE}, nothing is printed to screen as the function
runs.}

\item{thresh}{a number from 0 to 1. This will draw a line at that fraction of
multilocus genotypes, rounded. Defaults to 1, which will draw a line at the
maximum number of observable genotypes.}
}
\value{
(invisibly) a matrix of integers showing the results of each
  randomization. Columns represent the number of loci sampled and rows
  represent an independent sample.
}
\description{
GA curves are useful for determining the minimum number of loci necessary to
discriminate between individuals in a population. This function will randomly
sample loci without replacement and count the number of multilocus genotypes
observed.
}
\examples{
data(nancycats)
nan_geno <- genotype_curve(nancycats)
\dontrun{
# With AFLP data, it is often necessary to include more markers for resolution
data(Aeut)
Ageno <- genotype_curve(Aeut)

# Many microsatellite data sets have hypervariable markers
data(microbov)
mgeno <- geotype_curve(microbov)

# This data set has been pre filtered
data(monpop)
mongeno <- genotype_curve(monpop)}
}
\author{
Zhian N. Kamvar
}

