% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/El_Badry.R
\name{El_Badry}
\alias{El_Badry}
\title{El-Badry method}
\usage{
El_Badry(data, age, CEB, childs, req_ages = NULL)
}
\arguments{
\item{data}{data.drame. It contains at least three variables: five-year grouped ages, number of childs and Children Ever Born (CEB).}

\item{age}{variable name in \code{data} of the five-year grouped age.}

\item{CEB}{variable name in \code{data} with number of Children Ever Born .}

\item{childs}{variable name in \code{data} with the number of childs for each five-year grouped age and number of Children Ever Born.}

\item{req_ages}{optional character string that specifies the five-year grouped age to estimates the intercept.}
}
\value{
\code{Moultrie} returns a list with two elements: a data.frame with corrected children for each number of Children Ever Born and five-year grouped ages and a data.frame with combinations of five-year grouped age to estimate intercept, slope, and R-squared. By default, the method uses the best value of R-squared to apply the El Badry correction.
}
\description{
The method corrects the zero parity omission error.
}
\examples{

CEB_data <- tidyr::gather(CEB, ages, childs, -Children_Ever_Born)
results <- Moultrie(CEB_data, ages, childs, Children_Ever_Born)
CEB_data <- tidyr::pivot_wider(results, names_from=age, values_from=childs)
CEB_data <- tidyr::gather(CEB_data, ages, children, -CEB)
El_Badry(CEB_data,ages, CEB, children)


}
\references{
\insertRef{moultrie}{popstudy}
}
\seealso{
\code{\link{CEB}}
\code{\link{Moultrie}}
}
\author{
Cesar Gamboa-Sanabria
}
