% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_round.R
\name{pp_round}
\alias{pp_round}
\title{Rounding Function}
\usage{
pp_round(target, targetpop, sourcepop, sourcecode)
}
\arguments{
\item{target}{object of class \code{sf}}

\item{targetpop}{string of target estimated pop column}

\item{sourcepop}{string of source pop column}

\item{sourcecode}{string of source id column}
}
\value{
an object of class \code{sf} including rounded population counts
}
\description{
This function converts decimal population estimates produced by
    the \link[populR]{pp_estimate} approach into integer numbers that sum up
    to the source zone population counts
}
\examples{
    library(populR)

    data("target")
    data("source")

    # areametric
    pop_aw <- pp_estimate(source = source, target = target,
        sourcepop = pop, sourcecode = sid)

    # areametric round
    round_aw <- pp_round(target = pop_aw, targetpop = pp_est,
        sourcepop = pop, sourcecode = sid)

    # volumetric
    pop_vw <- pp_estimate(source = source, target = target,
    sourcepop = pop, sourcecode = sid, volume = floors)

    # volumetric round
    round_vw <- pp_round(target = pop_vw, targetpop = pp_est,
        sourcepop = "pop", sourcecode = sid)


}
