% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_monthly_timeseries.R
\name{make_timeseries}
\alias{make_timeseries}
\title{Makes a standardized monthly time series for Portal rodents}
\usage{
make_timeseries(data, date_format = "\%Y-\%m-\%d")
}
\arguments{
\item{data}{Dataframe with columns date (date of the period (e.g. 2016-01-01)), period
(period code for the census) and value (numeric value to be analyzed)}

\item{date_format}{format for the dattes in date column (e.g. "\%Y-\%m-\%d")}
}
\value{
dataframe containing 2 columns: newdate and value
}
\description{
The Portal rodent data is collected roughly monthly.
However, some time series methods require regular monthly data with no gaps.
This function deals with the issue that some monthly censuses occur slightly
before or after their intended sample month. The function takes a univariate
time series and pairs samples up with their intended month, averages out
double censuses that occur in the same month and interpolates gaps in the data.
To work properly the data should be a dataframe containing a single time series where
each date contains a single value.
}
