% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rodent_species.R
\name{na_conformer}
\alias{na_conformer}
\title{Conform NA entries to "NA" entries}
\usage{
na_conformer(dfv, colname = "species")
}
\arguments{
\item{dfv}{Either [1] a \code{data.frame} containing \code{colname} as a column with \code{NA}s that need to be conformed to \code{"NA"}s or [2] a vector with \code{NA}s that need to be conformed to \code{"NA"}s.}

\item{colname}{\code{character} value of the column name in \code{tab} to conform the \code{NA}s to \code{"NA"}s.}
}
\value{
\code{x} with any \code{NA} in \code{colname} replaced with \code{"NA"}.
}
\description{
Given the species abbreviation \emph{Neotoma albigula} (NA), when data are read in, there can be an \code{NA} when it should be an \code{"NA"}. This function conforms the entries to be proper character values.
}
\examples{
 na_conformer(c("a", "b", NA, "c"))

}
