% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/junrui.edit.R
\name{Tvol2}
\alias{Tvol2}
\title{Total Volumen of Activity for Whole Dataset}
\usage{
Tvol2(count.data, weartime, logtransform = FALSE, log.multiplier = 9250)
}
\arguments{
\item{count.data}{\code{data.frame} of dimension n*1442 containing the 1440 minute activity data for all n subject days.
The first two columns have to be ID and Day.}

\item{weartime}{\code{data.frame} with dimension of \code{count.data}.
The first two columns have to be ID and Day.}

\item{logtransform}{if \code{TRUE}, then calcualte \code{TLAC}. Or calculate \code{TAC}.}

\item{log.multiplier}{\code{number} The coefficient used in the log transformation of the ENMO data, i.e. log( log.multiplier * ENMO + 1). Defaut is 9250.}
}
\value{
A dataframe with some of the following columns
\item{ID}{identifier of the person}
\item{Day}{indicator of which day of activity it is, can be a numeric vector of sequence 1,2,... or a string of date}
\item{TAC}{total activity count}
\item{TLAC}{total log activity count}
}
\description{
Calculate total volume of activity level, which includes
\code{TLAC} (total log transfored activity counts),
\code{TAC} (total activity counts).
}
\details{
log transormation is defined as log(x+1).
}
