% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-apply.R
\name{rvar_apply}
\alias{rvar_apply}
\title{Random variable resulting from a function applied over margins of an array or random variable}
\usage{
rvar_apply(.x, .margin, .f, ...)
}
\arguments{
\item{.x}{An array or an \code{\link{rvar}}.}

\item{.margin}{(multiple options) The subscripts which the function will be applied over:
\itemize{
\item An integer vector. E.g., for a matrix \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows and columns.
\item A character vector of dimension names if \code{.x} has named dimensions.
}}

\item{.f}{(function) The function to be applied. The function \code{.f} must
return an \code{\link{rvar}} and the dimensions of the result of \code{.f} applied to each
margin of \code{.x} must be able to be broadcasted to a common shape (otherwise
the resulting \code{\link{rvar}} cannot be simplified). See \strong{Details}.}

\item{...}{Optional arguments passed to \code{.f}.}
}
\value{
An \code{\link{rvar}}.

If the result of each call to \code{.f} returns an \code{\link{rvar}} of dimension \code{d} after
being broadcast to a common shape, then \code{rvar_apply()} returns an \code{\link{rvar}} of
dimension \code{c(d, dim(.x)[.margin])}. If the last dimension of the result would
be \code{1}, it is dropped (other dimensions equal to \code{1} are retained). If \code{d} is
\code{0}, the result has length \code{0} but not necessarily the 'correct' dimension.
}
\description{
Returns an \code{\link{rvar}} obtained by applying a function to margins of an array or \code{\link{rvar}}.
Acts like \code{apply()}, except that the function supplied (\code{.f}) should return an \code{\link{rvar}},
and the final result is always an \code{\link{rvar}}.
}
\details{
This function acts much like \code{apply()}, except that the function passed to it (\code{.f})
must return \code{\link{rvar}}s, and the result is simplified into an \code{\link{rvar}}. Unlike
\code{apply()}, it also keeps the dimensions of the returned values along each margin,
rather than simplifying each margin to a vector, and if the results of \code{.f} do
not all have the same dimensions, it applies the \code{\link{rvar}} broadcasting rules to
bind results together rather than using vector recycling.

If you wish to apply functions over \code{\link{rvar}}s where the result is not intended to
be simplified into an \code{\link{rvar}}, you can use the standard \code{apply()}, \code{lapply()},
\code{sapply()}, or \code{vapply()} functions.
}
\examples{

set.seed(3456)
x <- rvar_rng(rnorm, 24, mean = 1:24)
dim(x) <- c(2,3,4)

# we can find the distributions of marginal means of the above array
# using rvar_mean along with rvar_apply
rvar_apply(x, 1, rvar_mean)
rvar_apply(x, 2:3, rvar_mean)

}
\seealso{
\code{\link[=as_rvar]{as_rvar()}} to convert objects to \code{rvar}s. See \code{\link[=rdo]{rdo()}}, \code{\link[=rfun]{rfun()}}, and
\code{\link[=rvar_rng]{rvar_rng()}} for higher-level interfaces for creating \code{rvar}s.
}
