% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.powdRlib}
\alias{plot.powdRlib}
\title{Plotting elements of a powdRlib object}
\usage{
\method{plot}{powdRlib}(x, patterns, interactive, ...)
}
\arguments{
\item{x}{a powdRlib object}

\item{patterns}{a character string of reference pattern id's to be plotted}

\item{interactive}{Logical. If TRUE then the output will be an interactive
ggplotly object. If FALSE then the output will be a ggplot object.}

\item{...}{other arguments}
}
\description{
\code{plot.powdRlib} is designed to provide easy, adaptable plots
of an XRPD reference library built using the \code{powdRlib} constructor
function.
}
\details{
The only mandatory argument is x, which must be a powdRlib object. Plots can
be made interactive using the logical \code{interactive} argument.
}
\examples{
# Load the minerals library
data(minerals)
\dontrun{
plot(minerals, patterns = "ALB")
plot(minerals, patterns = "ALB", interactive = TRUE)
}
}
