% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.powdRfps}
\alias{plot.powdRfps}
\title{Plotting elements of a powdRfps object}
\usage{
\method{plot}{powdRfps}(x, wavelength, mode, xlim, interactive, ...)
}
\arguments{
\item{x}{a powdRfps object}

\item{wavelength}{One of "Cu", "Co" or a custom numeric value defining the wavelength
(in Angstroms). Used to compute d-spacings.When "Cu" or "Co" are supplied, wavelengths
of 1.54056 or 1.78897 are used, respectively.}

\item{mode}{One of "fit", "residuals" or "both" defining whether to plot the fitted
patterns, the residuals of the fit, or both, respectively. Default = "fit".}

\item{xlim}{A numeric vector of length two providing limits of the x-axis. Defaults
to full x-axis unless specified.}

\item{interactive}{logical. If TRUE then the output will be an interactive
ggplotly object. If FALSE then the output will be a ggplot object.}

\item{...}{other arguments}
}
\description{
\code{plot.powdRfps} is designed to provide easy, adaptable plots
of full pattern summation outputs produced from \code{\link{fps}}.
}
\details{
When seeking to inspect the results from full pattern summation, interactive
plots are particularly useful and can be specified with the \code{interactive}
argument.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

\dontrun{
fps_sand <-  fps(lib = minerals,
                smpl = soils$sandstone,
                refs = minerals$phases$phase_id,
                std = "QUA.1",
                align = 0.2)

plot(fps_sand, wavelength = "Cu")
plot(fps_sand, wavelength = "Cu", interactive = TRUE)
}
}
