% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-bf.R
\name{plot_bf_assurance_curve}
\alias{plot_bf_assurance_curve}
\title{Plot Bayes Factor Assurance Curve (Multi-Effect Grid Friendly)}
\usage{
plot_bf_assurance_curve(
  power_results,
  bf_threshold = 3,
  x_effect = NULL,
  facet_by = NULL,
  effect_filters = NULL,
  effect_weights = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{List returned by \verb{brms_inla_power*} or two-stage variant.}

\item{bf_threshold}{Numeric; BF10 threshold to count as a "success" (default: 3).}

\item{x_effect}{Name of effect grid column for x-axis (default: first detected grid column).}

\item{facet_by}{Optional grid column(s) for faceting.}

\item{effect_filters}{Optional named list to restrict/show only selected grid rows, e.g. list(treatment=0).}

\item{effect_weights}{Optional named numeric vector of weights for selected x_effect values.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
ggplot object.
}
\description{
Plots the proportion of simulations in which BF10 meets or exceeds a threshold,
grouped by any effect grid variable(s) and sample size.
}
