% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess_inputs}
\alias{preprocess_inputs}
\alias{select_keys_and}
\alias{summarize_by_keys}
\alias{nest_by_keys}
\alias{pack_along_keys}
\alias{complete_keys}
\title{Preprocess powerjoin inputs}
\usage{
select_keys_and(.data, ...)

summarize_by_keys(.data, ...)

nest_by_keys(.data, ..., name = NULL)

pack_along_keys(.data, ..., name)

complete_keys(.data)
}
\arguments{
\item{.data}{A data frame to pivot.}

\item{...}{Additional arguments passed on to methods.}

\item{name}{Name of created column}
}
\value{
A data frame identical to the \code{.data} but with a \code{"powerjoin_preprocess"}
attribute to be handled by the join functions
}
\description{
These functions are named after the tidyverse functions \code{select}, \code{summarize},
\code{nest}, \code{pack}, \code{pivot_wider} and \code{pivot_longer} and are designed to avoid
repetition of key columns when preprocessing the data for a join. They should
only be used in the \code{x} and \code{y} arguments of {powerjoin} join functions. No
further transformation should be applied on top of them.
}
\details{
Unlike their tidyverse counterparts these just add an attribute to the input and
don't reshape it. The join function then preprocesses the inputs using these
attributes and the keys.
}
\examples{
# in practice you'll mostly use those in join function calls directly
x <- select_keys_and(head(iris, 2), Sepal.Width)
# all it does is add an attribute that will be processed by the join function
attr(x, "powerjoin_preprocess")
# see `?power_left_join` or README for practical examples
}
