% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztest.1samp.R
\name{ztest.1samp}
\alias{ztest.1samp}
\title{Power calculation for one-sample z test}
\usage{
ztest.1samp(
  N = NULL,
  delta = NULL,
  sd = 1,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{delta}{muA (the true mean) - mu0 (the mean under the null).}

\item{sd}{The standard deviation; defaults to 1.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for a one-sample z test
which is analogous to a one-sample t test with the variance assumed to be known.
This function is provided largely for pedagogical purposes; in general,
for real studies, the one-sample t test procedure should be used.
}
\examples{
ztest.1samp(N = NULL, delta = 6.5 - 5.7, sd = 2, power = 0.8, sides = 2)
ztest.1samp(N = 40, delta = NULL, sd = 1, power = 0.9, sides = 2)
ztest.1samp(N = NULL, delta = 0.6, sd = 1, power = 0.8, sides = 1)
}
