% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeoRate.R
\name{getGeoRate}
\alias{getGeoRate}
\title{getGeoRate}
\usage{
getGeoRate(envelope, tree, which.biovars, use.paleoclimate=TRUE, 
paleoclimateUser=NULL, layerAge=c(0:20))
}
\arguments{
\item{envelope}{the min and max climate envelope of each lineage for each time slice, as outputted by \code{getEnvelopes()}}

\item{tree}{the phylogeny of all species. An object of class phylo}

\item{which.biovars}{a vector of the numbers of the bioclimate variables to be included. The bioclimate variables number correspond to the table at (https://www.worldclim.org/data/bioclim.html).}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19. (see \code{getBioclimvars()}).}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}
}
\value{
\code{geo_center} change in geographic center of suitable climate envelope

\code{geo_size} change in geographic size of suitable climate envelope

\code{time_int} time intervals
}
\description{
This function calculates the change in suitable habitat through time in geographic space.
}
\details{
Calculates rate of geographic change of all lineages. Outputs both the geographic center change, and the geographic size change.
}
\examples{
data(sampletrees)
data(occurrences)
data(paleoclimate)
tree <- sampletrees[[25]]
occu <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(occu[,4],occu$Species,min)
sp_data_max<- tapply(occu[,4],occu$Species,max)
treedata_min <- geiger::treedata(tree,sp_data_min,sort=TRUE,warnings=F)
treedata_max <- geiger::treedata(tree,sp_data_max,sort=TRUE,warnings=F)
\donttest{full_est <- nodeEstimateEnvelopes(treedata_min,treedata_max)
node_est <- full_est$est
example_getEnvelopes <- getEnvelopes(treedata_min, treedata_max, node_est)
example_getGeoRate <- getGeoRate(example_getEnvelopes, tree, which.biovars=1)}
}
\seealso{
\code{getEnvelopes()}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard, Maria A. Hurtado-Materon
}
