% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md.distri.R
\name{md.distri}
\alias{md.distri}
\title{Mardia-Dryden distribution}
\usage{
md.distri(M_ref, n, sd = 0.05)
}
\arguments{
\item{M_ref}{a k x 2 refence matrix (usually the sample mean shape), where k is the number of 2D landmarks}

\item{n}{the number of observations}

\item{sd}{the standard deviation of the distribution (default = 0.02)}
}
\value{
the n x 2k matrix of shape coordinates drawn from a Mardia-Dryden distribution
}
\description{
Create a matrix of 2D shape coordinates drawn from a Mardia-Dryden distribution (3D not implemented)
}
\examples{
# 2D landmark coordinates
library("geomorph")
data("HomoMidSag")  # dataset
n_spec <- dim(HomoMidSag)[1]  # number of specimens
k <- dim(HomoMidSag)[2] / 2  # number of landmarks
homo_ar <- arrayspecs(HomoMidSag, k, 2)  # create an array

# Procrustes registration
homo_gpa <- Morpho::procSym(homo_ar)
m_mshape <- homo_gpa$mshape  # average shape

# Mardia-Dryden distribution
Xmd <- md.distri(m_mshape, n = n_spec, sd = 0.005)
# Visualization
plot(Xmd[, 1:k], Xmd[, (k+1):(2*k)], asp = 1, las = 1, cex = 0.5,
main = "Mardia-Dryden distribution", xlab = "X", ylab = "Y")

}
