% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xxyy.to.array.R
\name{xxyy.to.array}
\alias{xxyy.to.array}
\title{Convert landmark data matrix into array (p x k x n)}
\usage{
xxyy.to.array(M, p, k = 2)
}
\arguments{
\item{M}{A matrix of dimension n x [p x k] containing landmark coordinates for a set of specimens.
Each row contains all landmark coordinates for a single specimen.
The first columns correspond to the X coordinates for all landmarks, etc.}

\item{p}{Number of landmarks}

\item{k}{Number of dimensions (2 or 3)}
}
\value{
Function returns a 3D array (p x k x n),
where p is the number of landmark points,
k is the number of landmark dimensions (2 or 3),
and n is the number of specimens.
The third dimension of this array contains names for each specimen
if specified in the original input matrix.
}
\description{
Convert a matrix of landmark coordinates into a three-dimensional array
}
\examples{
X <- matrix(rnorm(40), nrow = 4) # Random 2D coordinates of 5 landmarks for 4 specimens
xxyy.to.array(X, 5, 2)

}
\seealso{
\code{\link{array.to.xxyy}}
}
