% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effSizCut.R
\name{effSizCut}
\alias{effSizCut}
\title{Compute Effect Sizes for continuous or categorical data}
\usage{
effSizCut(y, bigx, ane = TRUE)
}
\arguments{
\item{y}{{ (T x 1) vector of dependent variable data values}}

\item{bigx}{{ (T x p) data matrix of xi regressor variables associated
with the regression}}

\item{ane}{{logical variable controls the treatment of other regressors.
If ane=TRUE (default), other regressors are used in kernel regression
without forcing them to be binary variables. When ane=FALSE,
the kernel regression removes the effect of other regressors
when other regressors are also binary type categorical variables,}}
}
\value{
out vector with p values of t-statistics for p regressors
}
\description{
Psychologists' so-called "effect size" reveals
the practical significance of only one
regressor. This function generalizes their algorithm
to two or more regressors (p>2). Generalization first
converts the xi regressor into a categorical treatment variable
with only two categories. One imagines that observations
larger than the
median (xit> median(xi)) are "treated," and those
below the median are "untreated."
The aim is the measure the size of the
(treatment) effect of (xi) on y. Denote other variables
with postscript "o" as (xo). Since we have p regressors in
our multiple regression, we need to remove the nonlinear
kernel regression effect of
other variables (xo) on y while focusing on the effect of xi.
There are two options in treating (xo) (i) letting xo be
as they are in the data (ii) converting xo to binary
at the median. One chooses the first option (i) by setting the
logical argument ane=TRUE in calling the function.
ane=TRUE is the default. Set ane=FALSE for the second option.
}
\note{
The aim is to answer the following question.
Which regressor has the largest
effect on the dependent variable? We assume that the signs
of regressors are already adjusted such that a numerically
larger effect size suggests that the corresponding regressor
is most important, having the largest effect size in explaining
y the dependent variable.
}
\examples{
set.seed(9)
 y=sample(1:15,replace = TRUE)
 x1=sample(2:16, replace = TRUE)
 x2=sample(3:17, replace = TRUE)
effSizCut(y,bigx=cbind(x1,x2),ane=TRUE)

}
\seealso{
\code{\link{pracSig13}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
