% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mantel_comparison.R
\name{mantel_comparison}
\alias{mantel_comparison}
\title{Ensemble Mantel Tests}
\usage{
mantel_comparison(distance_matrices, labels = NULL, permutations = 1000)
}
\arguments{
\item{distance_matrices}{A list of document distance matrices generated by
the `scaling_comparison()` and returned in the `$distance_matrices` field.}

\item{labels}{Optional argument giving names for each preprocessing step.
This is generated by the `factorial_preprocessing()` function and returned in
the `$labels` field.}

\item{permutations}{The number of permutations to be used in each Mantel
test. Defaults to 1000.}
}
\value{
A result list object where the first entry is a matrix summarizing
mantel test statistics. The second object in the list is a matrix of the
values described above. The third object is a list of all raw mantel results.
}
\description{
Calculates Mantel test statistics for differences between
distance matrices for a list of distance matrices (one per preprocessing
method) supplied by the `scaling_comparison()` function.
}
\examples{
\dontrun{
# load the package
library(preText)
# load in the data
data("UK_Manifestos")
# preprocess data
preprocessed_documents <- factorial_preprocessing(
    UK_Manifestos,
    use_ngrams = TRUE,
    infrequent_term_threshold = 0.02,
    verbose = TRUE)
# scale documents
scaling_results <- scaling_comparison(preprocessed_documents$dfm_list,
                                      dimensions = 2,
                                      distance_method = "cosine",
                                      verbose = TRUE)
# run mantel tests
mantel_results <- mantel_comparison(scaling_results$distance_matrices,
                                    labels = preprocessed_documents$labels,
                                    permutations = 1000)
}
}

