% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_trials.R
\docType{methods}
\name{simulate_trials}
\alias{simulate_trials}
\alias{simulate_trials,selector_factory,numeric,hyper_mtdi_distribution-method}
\alias{simulate_trials,selector_factory,numeric,mtdi_distribution-method}
\title{Simulate trials defined via package \CRANpkg{escalation}}
\usage{
simulate_trials(selector_factory, num_sims, true_prob_tox, ...)

\S4method{simulate_trials}{selector_factory,numeric,hyper_mtdi_distribution}(selector_factory, num_sims, true_prob_tox, ...)

\S4method{simulate_trials}{selector_factory,numeric,mtdi_distribution}(selector_factory, num_sims, true_prob_tox, ...)
}
\arguments{
\item{selector_factory}{An object of S3 class \code{\link[escalation]{selector_factory}}}

\item{num_sims}{Number of simulations to run}

\item{true_prob_tox}{A generator of toxicity distributions}

\item{...}{Passed to subroutines}
}
\description{
An S4 generic method providing a more abstract interface to trial simulation than
the \code{\link[escalation]{simulate_trials}} function of package \code{escalation}.
This abstraction is needed to support simulations in which \code{escalation}'s simple
vectors of \sQuote{true toxicity probabilities} are replaced by \code{precautionary}'s
more realistic toxicity-distribution generators.
}
\details{
If invoked interactively with \code{num_sims} > 10, then a
\code{txtProgressBar} is displayed in the console. The condition on
\code{num_sims} has the useful side effect of allowing this function
to be invoked iteratively by \link{extend} (with \code{num_sims} = 10)
without the nuisance of nested progress bars.
}
\examples{
old <- options(dose_levels = c(0.5, 1, 2, 4, 6, 8))
mtdi_gen <- hyper_mtdi_lognormal(CV = 1
                                 , median_mtd = 6, median_sdlog = 0.5
                                 , units="mg/kg")
num_sims <- ifelse(interactive()
, 300
, 15 # avoid taxing CRAN servers
)
hsims <- get_three_plus_three(num_doses = 6) \%>\%
  simulate_trials(
    num_sims = num_sims
  , true_prob_tox = mtdi_gen)
summary(hsims, ordinalizer=NULL) # vanilla summary with binary toxicity
summary(hsims, ordinalizer = function(dose, r0 = sqrt(2))
  c(Gr1=dose/r0^2, Gr2=dose/r0, Gr3=dose, Gr4=dose*r0, Gr5=dose*r0^2)
)
hsims <- hsims \%>\% extend(num_sims = num_sims)
summary(hsims, ordinalizer = function(dose, r0 = sqrt(2))
  c(Gr1=dose/r0^2, Gr2=dose/r0, Gr3=dose, Gr4=dose*r0, Gr5=dose*r0^2)
)$safety
# Set a CRM skeleton from the average probs in above simulation
num_sims <- ifelse(interactive()
, 16
,  4  # avoid taxing CRAN servers
)
get_dfcrm(skeleton = hsims$avg_prob_tox
         ,target = 0.25
         ) \%>\% stop_at_n(n = 24) \%>\%
  simulate_trials(
    num_sims = num_sims
  , true_prob_tox = mtdi_gen
  ) -> crm_hsims
summary(crm_hsims
, ordinalizer = function(MTDi, r0 = sqrt(2))
    MTDi * r0^c(Gr1=-2, Gr2=-1, Gr3=0, Gr4=1, Gr5=2)
)
options(old)
old <- options(dose_levels = c(2, 6, 20, 60, 180, 400))
mtdi_dist <- mtdi_lognormal(CV = 0.5
                           ,median = 140
                           ,units = "ng/kg/week")
num_sims <- ifelse(interactive()
, 100
,  10  # avoid taxing CRAN servers
)
sims <- get_three_plus_three(num_doses = 6) \%>\%
  simulate_trials(
    num_sims = num_sims
  , true_prob_tox = mtdi_dist)
# Now set a proper ordinalizer via options():
options(ordinalizer = function(dose, r0) {
  c(Gr1=dose/r0^2, Gr2=dose/r0, Gr3=dose, Gr4=dose*r0, Gr5=dose*r0^2)
})
summary(sims, r0=2)
# Set a CRM skeleton from the average probs in above simulation
get_dfcrm(skeleton = sims$true_prob_tox
         ,target = 0.25
         ) \%>\% stop_at_n(n = 24) \%>\%
  simulate_trials(
    num_sims = 20
  , true_prob_tox = mtdi_dist
  ) -> crm_sims
summary(crm_sims
, ordinalizer = function(MTDi, r0 = sqrt(2))
    MTDi * r0^c(Gr1=-2, Gr2=-1, Gr3=0, Gr4=1, Gr5=2)
)
if (interactive()) { # don't overtax CRAN servers
crm_sims <- crm_sims \%>\% extend(target_mcse = 0.1)
summary(crm_sims
, ordinalizer = function(MTDi, r0 = sqrt(2))
    MTDi * r0^c(Gr1=-2, Gr2=-1, Gr3=0, Gr4=1, Gr5=2)
)$safety
}
options(old)
}
