% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccd.R
\name{Ccd-class}
\alias{Ccd-class}
\alias{Ccd}
\title{An R6 class encapsulating Cumulative-Cohort Designs}
\description{
An R6 class encapsulating Cumulative-Cohort Designs

An R6 class encapsulating Cumulative-Cohort Designs
}
\details{
TODO: Explain the hierarchy of model classes, including connections
with the executable specifications set forth in \code{exec/prolog/ccd.pl}.
}
\examples{

## ------------------------------------------------
## Method `Ccd$new`
## ------------------------------------------------

# TODO
}
\references{
\enumerate{
\item Ivanova A, Flournoy N, Chung Y. Cumulative cohort design for dose-finding.
Journal of Statistical Planning and Inference. 2007;137(7):2316-2327.
\doi{10.1016/j.jspi.2006.07.009}
\item Liu S, Yuan Y. Bayesian optimal interval designs for phase I clinical trials.
J R Stat Soc C. 2015;64(3):507-523. \doi{10.1111/rssc.12089}
}
}
\section{Super class}{
\code{\link[precautionary:Cpe]{precautionary::Cpe}} -> \code{Ccd}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Ccd$new()}}
\item \href{#method-applied}{\code{Ccd$applied()}}
\item \href{#method-clone}{\code{Ccd$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="J">}\href{../../precautionary/html/Cpe.html#method-J}{\code{precautionary::Cpe$J()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="bU">}\href{../../precautionary/html/Cpe.html#method-bU}{\code{precautionary::Cpe$bU()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="max_dose">}\href{../../precautionary/html/Cpe.html#method-max_dose}{\code{precautionary::Cpe$max_dose()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_array">}\href{../../precautionary/html/Cpe.html#method-path_array}{\code{precautionary::Cpe$path_array()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_matrix">}\href{../../precautionary/html/Cpe.html#method-path_matrix}{\code{precautionary::Cpe$path_matrix()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_probs">}\href{../../precautionary/html/Cpe.html#method-path_probs}{\code{precautionary::Cpe$path_probs()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="path_rx">}\href{../../precautionary/html/Cpe.html#method-path_rx}{\code{precautionary::Cpe$path_rx()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="report">}\href{../../precautionary/html/Cpe.html#method-report}{\code{precautionary::Cpe$report()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="precautionary" data-topic="Cpe" data-id="trace_paths">}\href{../../precautionary/html/Cpe.html#method-trace_paths}{\code{precautionary::Cpe$trace_paths()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ccd$new(escalate, deescalate, eliminate, cohort_max, enroll_max)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{escalate}}{Escalation boundary}

\item{\code{deescalate}}{Deescalation boundary}

\item{\code{eliminate}}{Elimination boundary}

\item{\code{cohort_max}}{Upper bound on dose-wise enrollment}

\item{\code{enroll_max}}{Upper bound on total enrollment}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new \code{Ccd} object.
}

\subsection{Returns}{
A \code{Ccd} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# TODO
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-applied"></a>}}
\if{latex}{\out{\hypertarget{method-applied}{}}}
\subsection{Method \code{applied()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ccd$applied(x, o, last_dose, max_dose, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A dose-wise vector of toxicity counts}

\item{\code{o}}{A dose-wise vector of non-toxicity counts}

\item{\code{last_dose}}{The most recently given dose, as required to implement
cumulative-cohort-based escalation decisions.}

\item{\code{max_dose}}{An upper limit on future dose levels}

\item{\code{...}}{Unused by \code{Ccd}; included for superclass method compatibility}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return dose recommendation for given tox/no-tox tallies.
}

\subsection{Returns}{
An object with components:
\itemize{
\item \verb{$stop} - logical value indicating whether stop is indicated
\item \verb{$mtd} - integer value, the recommended dose
\item \verb{$max_dose} - integer value, a dose not to be exceeded henceforth.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ccd$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
