% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_auc.R
\name{auc}
\alias{auc}
\alias{auc.aucs}
\title{Retrieve a data frame of AUC scores}
\usage{
auc(curves)

\method{auc}{aucs}(curves)
}
\arguments{
\item{curves}{An S3 object generated by \code{\link{evalmod}}.
  The \code{auc} function takes one of the following S3 objects.

  \tabular{lllll}{
    \strong{S3 object}
    \tab \tab \strong{# of models}
    \tab \tab \strong{# of test datasets} \cr

    sscurves \tab \tab single   \tab \tab single   \cr
    mscurves \tab \tab multiple \tab \tab single   \cr
    smcurves \tab \tab single   \tab \tab multiple \cr
    mmcurves \tab \tab multiple \tab \tab multiple
  }}
}
\value{
The \code{auc} function returns a data frame with the AUC scores.
}
\description{
The \code{auc} function takes an S3 object generated by
  \code{\link{evalmod}} and retrieves a data frame with the Area Under
  the Curve (AUC) scores of the ROC and Precision-Recall curves.
}
\examples{

#############################################################################
### Single model & single test dataset
###

## Load a dataset with 10 positives and 10 negatives
data(P10N10)

## Generate an sscurve object that contains ROC and Precision-Recall curves
sscurves <- evalmod(scores = P10N10$scores, labels = P10N10$labels)

## Shows AUCs
auc(sscurves)


#############################################################################
### Multiple models & single test dataset
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(1, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mscurves <- evalmod(mdat)

## Shows AUCs
auc(mscurves)


#############################################################################
### Single model & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "good_er")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an smcurve object that contains ROC and Precision-Recall curves
smcurves <- evalmod(mdat, raw_curves = TRUE)

## Get AUCs
sm_aucs <- auc(smcurves)

## Get AUCs of Precision-Recall
sm_aucs_prc <- subset(sm_aucs, curvetypes == "PRC")


#############################################################################
### Multiple models & multiple test datasets
###

## Create sample datasets with 100 positives and 100 negatives
samps <- create_sim_samples(10, 100, 100, "all")
mdat <- mmdata(samps[["scores"]], samps[["labels"]],
               modnames = samps[["modnames"]],
               dsids = samps[["dsids"]])

## Generate an mscurve object that contains ROC and Precision-Recall curves
mmcurves <- evalmod(mdat, raw_curves = TRUE)

## Shows AUCs
mm_aucs <- auc(mmcurves)

## Get AUCs of Precision-Recall
mm_aucs_prc <- subset(mm_aucs, curvetypes == "PRC")

}
\seealso{
\code{\link{evalmod}} for generating S3 objects with performance
  evaluation measures.
}

