% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_merge.R
\name{file_merge}
\alias{file_merge}
\title{Vertically Merge Files in a Directory into a Single Large Dataset}
\usage{
file_merge(file_name = "dataset.txt", save_table = TRUE,
  notification = TRUE)
}
\arguments{
\item{file_name}{A string with the name of the file of the large dataset the
function returns in case \code{save_table} is \code{TRUE}. Default is
\code{"dataset.txt"}.}

\item{save_table}{Logical. If TRUE, saves the dataset into a txt file.
Default is \code{"dataset.txt"}.}

\item{notification}{Logical. If TRUE, prints messages about the progress of
the function. Default is \code{TRUE}.}
}
\value{
The merged dataset \code{dataset}.
}
\description{
Vertically concatenates files containing data tables in a long
  format into a single large dataset. In order for the function to work, all
  files you wish to merge should be put in one folder containing nothing but
  these files. In addition, the working directory should be set to that
  folder and all files should be in the same format (either txt or csv).
  This function is very useful for concatenating raw data files of
  individual subjects in an experiment (in which each line corresponds to a
  single observation in the experiment) to one raw data file that includes
  all subjects.
}

