% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{select_steps}
\alias{select_steps}
\title{Select steps}
\usage{
select_steps(
  pressure_data,
  threshold = 20,
  min_frames = 10,
  n_steps = 5,
  skip = 2
)
}
\arguments{
\item{pressure_data}{List. First item should be a 3D array covering each
timepoint of the measurement. z dimension represents time.}

\item{threshold}{Numeric. Threshold force to define start and end of step}

\item{min_frames}{Numeric. Minimum number of frames that need to be in step}

\item{n_steps}{Numeric. Target number of steps/cycles. User will be
asked to keep selected steps until this target is reached or they run out of
candidate steps}

\item{skip}{Numeric. Usually the first few steps of a trial are accelerating
and not representative of steady state walking so this removes them}
}
\value{
\itemize{
  \item pressure_array. 3D array covering each timepoint of the measurement.
           z dimension represents time
  \item pressure_system. String defining pressure system
  \item sens_size. Numeric vector with the dimensions of the sensors
  \item time. Numeric value for time between measurements
  \item masks. List
  \item events. List
  }
}
\description{
Select steps, usually from insole data, and format for analysis
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pedar_data <- system.file("extdata", "pedar_example.asc", package = "pressuRe")
pressure_data <- load_pedar(pedar_data)
pressure_data <- select_steps(pressure_data)
\dontshow{\}) # examplesIf}
}
