\docType{package}

\name{pricesensitivitymeter}
\alias{pricesensitivitymeter}
\alias{pricesensitivitymeter-package}

\title{Consumer Price Preferences and Price Sensitivity Analysis}

\description{
pricensitivitymeter is an implementation of the van Westendorp
  Price Sensitivity Meter method to analyze consumer price
  preferences and price sensitivity in R. Besides the estimation
  of optimal price points and price ranges, it can also model
  the optimal price in terms of reach or revenue (based on the
  so-called Newton Miller Smith extension).

  To read the documentation for the function's syntax,
  see \code{\link{psm_analysis}} and
  \code{\link{psm_analysis_weighted}} (for weighted data).
}

\author{
Max Alletsee \email{max.alletsee@gmail.com}
}

\references{
  Van Westendorp, P (1976) "NSS-Price Sensitivity Meter (PSM) --
  A new approach to study consumer perception of price"
  \emph{Proceedings of the 29th ESOMAR Congress}, 139--167. Online
  available at \url{https://www.researchworld.com/a-new-approach-to-study-consumer-perception-of-price/}.

  Newton, D, Miller, J, Smith, P, (1993) "A market acceptance
  extension to traditional price sensitivity measurement"
  \emph{Proceedings of the American Marketing Association
  Advanced Research Techniques Forum}.
}

\seealso{
Useful links:
\itemize{
\item \url{https://github.com/max-alletsee/pricesensitivitymeter}
\item Report bugs at
  \url{https://github.com/max-alletsee/pricesensitivitymeter/issues}
}
}
