% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.R
\name{phi}
\alias{phi}
\title{Euler's Totient Function}
\usage{
phi(n)
}
\arguments{
\item{n}{an integer vector.}
}
\value{
An integer vector.
}
\description{
Compute Euler's Totient Function (\eqn{\phi(n)}{phi(n)}). Provides the
count of \eqn{k} integers that are coprime with \eqn{n} such that
\eqn{1 \le k \le n}{1 <= k <= n} and \eqn{gcd(n,k) = 1}{gcd(n, k) == 1}.
}
\examples{
phi(12)
## [1] 4

phi(c(9, 10, 142))
## [1]  6  4 70

}
\references{
"Euler's totient function" (2020) Wikipedia.
https://en.wikipedia.org/wiki/Euler\%27s_totient_function (Accessed 21 Aug
2020).
}
\seealso{
\code{\link{gcd}}, \code{\link{coprime}}, \code{\link{prime_factors}}
}
\author{
Paul Egeler, MS
}
