% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{zones}
\alias{zones}
\alias{Zones-class}
\alias{ZonesCharacter}
\alias{ZonesRaster}
\alias{Zones}
\title{Management zones}
\usage{
zones(..., zone_names = NULL, feature_names = NULL)
}
\arguments{
\item{...}{\code{\link[raster:raster]{raster::raster()}} or \code{character} objects that
pertain to the biodiversity data. See Details for more information.}

\item{zone_names}{\code{character} names of the management zones. Defaults
to \code{NULL} which results in sequential integers.}

\item{feature_names}{\code{character} names of the features zones. Defaults
to \code{NULL} which results in sequential integers.}
}
\value{
\code{\linkS4class{Zones}} object.
}
\description{
Organize data for multiple features for multiple management zones.
Specifically, the data should describe the expected amount of each
feature within each planning unit given each management zone.
For example, the data could describe the occupancy
(e.g. presence/absence), probability of occurrence, or
abundance expected for each feature when each planning unit
is allocated to a different zone.
}
\details{
This function is used to store and organize data for use in a
conservation planning \code{\link[=problem]{problem()}} that has multiple management
zones.
In all cases, the data for each zone is input as a separate argument.
The correct arguments depends on the type of planning unit data
used when building the conservation planning \code{\link[=problem]{problem()}}.

\describe{
\item{planning unit data are a \code{\linkS4class{Raster}} or \code{\linkS4class{Spatial}} object}{
\code{\linkS4class{Raster}} object can be supplied to specify the expected amount of
each feature within each planning unit under each management zone.
Data for each zone should be specified as separate
arguments, and the data for each feature in a given zone are specified
in separate layers in a \code{\link[raster:stack]{raster::stack()}} object.
Note that all layers for a given zone must have \code{NA} values in exactly the
same cells.}
\item{planning unit data are a \code{\linkS4class{Spatial}} or \code{data.frame}
object}{\code{character} vector containing column names can
be supplied to specify the expected amount of each feature under each
zone. Note that these columns must not contain any \code{NA} values.}
\item{planning unit data are a \code{\linkS4class{Spatial}}, \code{data.frame}, or
\code{matrix} object}{\code{data.frame} object can be supplied to specify the
expected amount of each feature under each zone.
Following conventions used in \emph{Marxan}, the
\code{data.frame} object should contain the following columns.
\describe{
\item{pu}{\code{integer} planning unit identifier.}
\item{species}{\code{integer} feature identifier.}
\item{amount}{\code{numeric} amount of the feature in the
planning unit for a given zone.}
}
Note that data for each zone are specified in a separate argument, and
the data contained in a single \code{data.frame} object should correspond to
a single zone. Also, note that data are not required for all
combinations of planning units, features, and zones. The expected amount of
features in planning units under management zones that are
missing from the table are assumed to be zero.}
}
}
\examples{
\dontrun{
# load planning unit data
data(sim_pu_raster)

# (note this requires the RandomFields package to be installed)
zone_1 <- simulate_species(sim_pu_raster, 3)
zone_2 <- simulate_species(sim_pu_raster, 3)

# create zones using two raster stack objects
# each object corresponds to a different zone and each layer corresponds to
# a different species
z <- zones(zone_1, zone_2, zone_names = c("zone_1", "zone_2"),
           feature_names = c("feature_1", "feature_2", "feature_3"))
print(z)

# note that the do.call function can also be used to create a Zones object
# this method for creating a Zones object can be helpful when there are many
# management zones
l <- list(zone_1, zone_2, zone_names = c("zone_1", "zone_2"),
          feature_names = c("feature_1", "feature_2", "feature_3"))
z <- do.call(zones, l)
print(z)

# create zones using character vectors that represent the names of
# fields (columns) in a data.frame or Spatial object that contain the amount
# of each species expected different management zones
z <- zones(c("spp1_zone1", "spp2_zone1"),
           c("spp1_zone2", "spp2_zone2"),
           c("spp1_zone3", "spp2_zone3"),
           zone_names = c("zone1", "zone2", "zone3"),
           feature_names = c("spp1", "spp2"))
print(z)
}
}
\seealso{
\code{\link[=problem]{problem()}}.
}
