% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{congress}
\alias{congress}
\title{Congressional election data}
\format{
\subsection{\code{congress}}{

A data frame with 9,788 rows and 15 columns:
\describe{
\item{state}{State code (ICPSR coding)}
\item{district}{District code}
\item{demvote}{Number of votes for Democrat candidate}
\item{repvote}{Number of votes for Republican candidate}
\item{year}{Year of election}
\item{demvoteshare}{Percentage of vote for Democrat candidate}
\item{lagdemvoteshare}{Percentage of vote for Democrat candidate in last election}
\item{totpop}{Population of Congressional district}
\item{medianincome}{Median (nominal) income of Congressional district}
\item{pcturban}{Percentage of Congressional district that is urban}
\item{pctblack}{Percentage of Congressional district that is black}
\item{pcthighschl}{Percentage of Congressional district that is HS graduates}
\item{votingpop}{Voting population of Congressional district}
\item{democrat}{1 if Democrat wins election (demvoteshare>0.5), 0 otherwise}
\item{lagdemocrat}{1 if Democrat won last election (lagdemvoteshare>0.5), 0 otherwise}
}
}
}
\source{
\url{https://eml.berkeley.edu/\%7Emoretti/data3.html}
}
\usage{
congress
}
\description{
Data on congressional election outcomes in the United States between 1948 and 1990,
based upon the paper "Do Voters Affect or Elect Policies? Evidence from the
U.S. House" by David S. Lee, Enrico Moretti, Matthew J. Butler, 2004,
Quarterly Journal of Economics, 119: 807-859. This sample is restricted to
elections where (i) the incumbent is running for re-election and (ii) are not
running unopposed. There are 9,788 observations available, and demographic
variables are available for 6,774 of the observations.
}
\keyword{datasets}
