% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_mean_indep.R, R/var_mean_onesample.R,
%   R/var_prop_indep.R
\name{var_mean_indep}
\alias{var_mean_indep}
\alias{var_mean_onesample}
\alias{var_prop_indep}
\title{Variance helper functions}
\usage{
var_mean_indep(x_vectors)

var_mean_onesample(df, vars = names(df))

var_prop_indep(pi_hat, nobs)
}
\arguments{
\item{x_vectors}{A list of vectors, representing the different
independent samples.}

\item{df}{A data.frame object}

\item{vars}{A character vector of variable names in \code{df}.}

\item{pi_hat}{A vector of sample proportions.}

\item{nobs}{The sample size.}
}
\value{
A matrix, representing the asymptotic covariance matrix
of the sample means.
}
\description{
These functions help calculate the variance matrix of different
kinds of samples. \code{var_mean_indep} creates an asymptotic
covariance matrix for the sample means of a list of independent
samples. \code{var_prop_indep} creates an asymptotic covariance
matrix for the sample proportions of a list of independent
samples. \code{var_mean_onesample} creates an asymptotic covariance
matrix for the sample means of several variables from the same
sample.
}
\examples{
# list of independent samples
x_vectors <- list(
  rnorm(1000, mean = 1, sd = 2),
  rnorm(10, mean = 4, sd = 0.5),
  rnorm(1000000, mean = 0, sd = 1)
)
var_mean_indep(x_vectors)

# sample proportions
pi_hat <- c(0.1, 0.6, 0.3)
nobs <- 1000
var_prop_indep(pi_hat, nobs)

# covariance of educ and age in cps dataset
var_mean_onesample(cps, c("educ", "age"))

}
