% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCatVars.R
\name{getYhat}
\alias{getYhat}
\title{Get predicted value from object of class "lm"}
\usage{
getYhat(fit, group = "D", mode = 1)
}
\arguments{
\item{fit}{Object of class "lm"}

\item{group}{names of dummy variables in  formula}

\item{mode}{Numeric. One of 1:4. 1= simple indicator coding, 2= sequential coding, 3= Helmert coding, 4= effect coding}
}
\description{
Get predicted value from object of class "lm"
}
\examples{
iris1=addCatVars(iris,c("Species"))
iris3=addCatVars(iris,c("Species"),mode=3)
fit1=lm(Sepal.Length~Sepal.Width+D1+D2,data=iris1)
getYhat(fit1)
fit1=lm(Sepal.Length~D2*Sepal.Width+Sepal.Width*D1+Petal.Width,data=iris1)
getYhat(fit1)
fit3=lm(Sepal.Length~D2*Sepal.Width+Sepal.Width*D1+Petal.Width*D1+Petal.Width*D2,data=iris3)
getYhat(fit3,mode=3)
}
