% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pprof.R
\name{serve_rprof}
\alias{serve_rprof}
\title{Visualize Rprof() output with pprof.}
\usage{
serve_rprof(
  rprof,
  host = "localhost",
  port = NULL,
  browse = interactive(),
  verbose = TRUE
)
}
\arguments{
\item{rprof}{Path to profiling samples generated
by \code{Rprof()} or \code{\link[=record_rprof]{record_rprof()}}.}

\item{host}{Host name. Set to \code{"localhost"} to view locally
or \code{"0.0.0.0"} to view from another machine. If you view
from another machine, the printed out URL will not be valid.
For example, if \code{pprof()} or \code{serve_pprof()} prints
"http://0.0.0.0:8080", then you need to replace 0.0.0.0
with your computer's name or IP address, e.g.
"http://my_computer.com:8080".}

\item{port}{Port number for hosting the local pprof server.
Chosen randomly by default.}

\item{browse}{Logical, whether to open a browser to view
the pprof server.}

\item{verbose}{Logical, whether to print console messages
such as the URL of the local \code{pprof} server.}
}
\value{
A \code{processx::process$new()} handle. Use this handle
to take down the server with \verb{$kill()}.
}
\description{
Use pprof to visualize profiling data
produced by \code{Rprof()} or \code{\link[=record_rprof]{record_rprof()}}.
}
\details{
Uses a local interactive server.
Navigate a browser to a URL in the message.
The server starts in a background process
}
\examples{
\dontrun{
rprof <- record_rprof(replicate(1e2, sample.int(1e4)))
# Start a pprof virtual server in the background.
px <- serve_rprof(rprof)
# Terminate the server.
px$kill()
}
}
