% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_shiny.R
\name{handler_shiny}
\alias{handler_shiny}
\title{Progression Handler: Progress Reported via 'shiny' Widgets (GUI) in the HTML Browser}
\usage{
handler_shiny(
  intrusiveness = getOption("progressr.intrusiveness.gui", 1),
  target = "gui",
  ...
)
}
\arguments{
\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \pkg{shiny} and \code{\link[shiny:withProgress]{shiny::withProgress()}}.
}
\details{
For most Shiny application there is little need to use this Shiny handler
directly.  Instead, it is sufficient to use \code{\link[=withProgressShiny]{withProgressShiny()}}.
}
\section{Requirements}{

This progression handler requires the \pkg{shiny} package.
}

\examples{
\donttest{\dontrun{
handlers(handler_shiny())
with_progress(y <- slow_sum(1:100))
}}

}
\keyword{internal}
