% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_path.R
\name{gantt}
\alias{gantt}
\title{Creates a Gantt chart of tasks in a project.}
\usage{
gantt(df, start_date = Sys.Date())
}
\arguments{
\item{df}{Task input. This can either be a data frame of raw data
(i.e not from the 'critical_path' function) or can the return value from calling
the 'critical path' function.
If the data is raw, if must have columns "ID, name, duration, dependencies"
in that order. These columns need not be named but they must be in that order.
Type 'taskdata1' into the console for an example of raw data.}

\item{start_date}{Starting date for the project. Defaults to the current date.}
}
\value{
A gantt chart for the tasks. If data has been processed by the critical path function,
then this gantt chart will color the critical path elements.
}
\description{
Creates a Gantt chart of tasks in a project.
}
\examples{
# Use raw example data
data <- taskdata1
# Create a gantt chart using the raw data
gantt(data)

res <- critical_path(data)

# Create a second gantt chart using the processed data
gantt(res)

}
