% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo-ref.R
\name{create_repo_ref}
\alias{create_repo_ref}
\title{Create reference to a GitHub repository}
\usage{
create_repo_ref(repo_owner, repo_name, is_enterprise = FALSE,
  hostname = "", identifier = "")
}
\arguments{
\item{repo_owner}{Repository owner's username or GitHub Organization name}

\item{repo_name}{Repository name}

\item{is_enterprise}{Boolean denoting whether or not working with Enterprise GitHub.Defaults to \code{FALSE}}

\item{hostname}{Host URL stub for Enterprise repositories (e.g. "mycorp.github.com")}

\item{identifier}{Ideally should be left blank and defaults to using \code{GITHUB_PAT} or \code{GITHUB_ENT_PAT}
environment variables as Personal Access Tokens. If \code{identifier},
this is assumed to be an alternative name of the environment variable to use for your Personal Access Token}
}
\value{
List of repository reference information and credentials
}
\description{
This function constructs a list of needed information to send API calls to a specific
GitHub repository. Specifically, it stores information on the repository's name and
owner, the type (whether or not Enterprise GitHub), and potentially credentials to authenticate.
}
\details{
Note that this package can be used for GET requests on public repositories without any authentication
(resulting in a lower rate limit.) To do this, simply pass any string into \code{identifier} that is not
an environment variable already defined for your system (e.g. accessible through \code{Sys.getenv("MY_VAR")})
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
}

}
