% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/411.p-Confidence_p-Bias_ADJ_All.R
\name{pCOpBIAAll}
\alias{pCOpBIAAll}
\title{Performs p-Confidence and p-Bias estimation of 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine) given adding factor}
\usage{
pCOpBIAAll(n, alp, h)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}
}
\value{
A dataframe with
 \item{x1}{  Number of successes (positive samples)}
 \item{pconf }{   p-Confidence}
 \item{pbias }{   p-Bias}
 \item{method}{Method name}
}
\description{
Performs p-Confidence and p-Bias estimation of 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine) given adding factor
}
\details{
Evaluation of p-Confidence and p-Bias estimation of 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\examples{
n=5; alp=0.05;h=2
pCOpBIAAll(n,alp,h)
}
\references{
[1] 2005 Vos PW and Hudson S.
Evaluation Criteria for Discrete Confidence Intervals: Beyond Coverage and Length.
The American Statistician: 59; 137 - 142.
}
\seealso{
Other p-confidence and p-bias of adjusted methods: \code{\link{PlotpCOpBIAAS}},
  \code{\link{PlotpCOpBIAAll}},
  \code{\link{PlotpCOpBIALR}}, \code{\link{PlotpCOpBIALT}},
  \code{\link{PlotpCOpBIASC}}, \code{\link{PlotpCOpBIATW}},
  \code{\link{PlotpCOpBIAWD}}, \code{\link{pCOpBIAAS}},
  \code{\link{pCOpBIALR}}, \code{\link{pCOpBIALT}},
  \code{\link{pCOpBIASC}}, \code{\link{pCOpBIATW}},
  \code{\link{pCOpBIAWD}}
}

