% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/631.BayesFactors.R
\name{hypotestBAF4}
\alias{hypotestBAF4}
\title{Bayesain Hypothesis testing :Hypothesis 4: Theta <= Theta0 Vs Theta > Theta0}
\usage{
hypotestBAF4(n, th0, a0, b0, a1, b1)
}
\arguments{
\item{n}{- Number of trials from data}

\item{th0}{- Hypothetical parameter for H0}

\item{a0}{- Priors for hypothesis H0}

\item{b0}{- Priors for hypothesis H0}

\item{a1}{- Priors for hypothesis H1}

\item{b1}{- Priors for hypothesis H1}
}
\value{
A dataframe with
 \item{x}{ Number of successes}
 \item{BaFa01}{ Bayesian Factor}
}
\description{
Bayesain Hypothesis testing :Hypothesis 4: Theta <= Theta0 Vs Theta > Theta0
}
\details{
Computes Bayes factor under Beta-Binomial model for the
model: \eqn{p <= p0} Vs \eqn{p > p0} from the given number of trials \code{n} and for all number
of successes \eqn{x = 0, 1, 2......n }
We use the following guideline for reporting the results:
\itemize{
\item  1/3 <= BaFa01 < 1: Evidence against H0 is not worth more than a bare mention.
\item  1/20 <= BaFa01 < 1/3: Evidence against H0 is positive.
\item  1/150 <= BaFa01 < 1/20: Evidence against H0 is strong.
\item  BaFa10 < 1/150: Evidence against H0 is very strong.
\item  1 <= BaFa01 < 3: Evidence against H1 is not worth more than a bare mention.
\item  3 <= BaFa01 < 20: Evidence against H1 is positive.
\item  20 <= BaFa01 < 150: Evidence against H1 is strong.
\item  150 <= BaFa01: Evidence against H1 is very strong.}
}
\examples{
n=10; th0=0.1; a0=0.5; b0=0.5; a1=1; b1=1
hypotestBAF4(n,th0,a0,b0,a1,b1)
}
\references{
[1] 2006  Ghosh M, Delampady M and Samanta T.
An introduction to Bayesian analysis: Theory and Methods.
Springer, New York

[2] 2014 Sakthivel S, Subbiah M and Ramakrishnan R
Default prior approach for Bayesian testing of hypotheses involving single binomial proportion
International Journal of Statistics and Analysis, 4 (2), 139 - 153
}
\seealso{
Other Hypothesis testing: \code{\link{hypotestBAF1x}},
  \code{\link{hypotestBAF1}}, \code{\link{hypotestBAF2x}},
  \code{\link{hypotestBAF2}}, \code{\link{hypotestBAF3x}},
  \code{\link{hypotestBAF3}}, \code{\link{hypotestBAF4x}},
  \code{\link{hypotestBAF5x}}, \code{\link{hypotestBAF5}},
  \code{\link{hypotestBAF6x}}, \code{\link{hypotestBAF6}}
}
