% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/311.Expec_Leng_ADJ_All.R
\name{lengthALR}
\alias{lengthALR}
\title{Performs expected length and sum of length of Adjusted Likelihood method
Performs expected length and sum of length of Adjusted Likelihood method}
\usage{
lengthALR(n, alp, h, a, b)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}
}
\value{
A dataframe with
 \item{sumLen}{  The sum of the expected length}
 \item{explMean}{  The mean of the expected length}
 \item{explSD}{  The Standard Deviation of the expected length}
 \item{explMax}{  The max of the expected length}
 \item{explLL}{  The Lower limit of the expected length calculated using mean - SD}
 \item{explUL}{  The Upper limit of the expected length calculated using mean + SD}
}
\description{
Performs expected length and sum of length of Adjusted Likelihood method
Performs expected length and sum of length of Adjusted Likelihood method
}
\details{
Evaluation of adjusted Likelihood ratio limits using sum of length of the \eqn{n + 1} intervals
}
\examples{
n= 10; alp=0.05; h=2;a=1;b=1;
lengthALR(n,alp,h,a,b)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
Other Expected length  of adjusted methods: \code{\link{PlotexplAAS}},
  \code{\link{PlotexplAAll}}, \code{\link{PlotexplALR}},
  \code{\link{PlotexplALT}}, \code{\link{PlotexplASC}},
  \code{\link{PlotexplATW}}, \code{\link{PlotexplAWD}},
  \code{\link{PlotlengthAAS}},
  \code{\link{PlotlengthAAll}},
  \code{\link{PlotlengthALR}}, \code{\link{PlotlengthALT}},
  \code{\link{PlotlengthASC}}, \code{\link{PlotlengthATW}},
  \code{\link{PlotlengthAWD}}, \code{\link{lengthAAS}},
  \code{\link{lengthAAll}}, \code{\link{lengthALT}},
  \code{\link{lengthASC}}, \code{\link{lengthATW}},
  \code{\link{lengthAWD}}
}
