% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/411.p-Confidence_p-Bias_ADJ_All.R
\name{pCOpBIAWD}
\alias{pCOpBIAWD}
\title{p-Confidence and p-Bias estimation for adjusted Wald method}
\usage{
pCOpBIAWD(n, alp, h)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}
}
\value{
A dataframe with
 \item{x1}{  Number of successes (positive samples)}
 \item{pconf }{   p-Confidence}
 \item{pbias }{   p-Bias}
}
\description{
p-Confidence and p-Bias estimation for adjusted Wald method
}
\details{
Evaluation of adjusted Wald-type
interval using p-confidence and p-bias for the \eqn{n + 1} intervals
}
\examples{
n=5; alp=0.05;h=2
pCOpBIAWD(n,alp,h)
}
\references{
[1] 2005 Vos PW and Hudson S.
Evaluation Criteria for Discrete Confidence Intervals: Beyond Coverage and Length.
The American Statistician: 59; 137 - 142.
}
\seealso{
Other p-confidence and p-bias of adjusted methods: \code{\link{PlotpCOpBIAAS}},
  \code{\link{PlotpCOpBIAAll}},
  \code{\link{PlotpCOpBIALR}}, \code{\link{PlotpCOpBIALT}},
  \code{\link{PlotpCOpBIASC}}, \code{\link{PlotpCOpBIATW}},
  \code{\link{PlotpCOpBIAWD}}, \code{\link{pCOpBIAAS}},
  \code{\link{pCOpBIAAll}}, \code{\link{pCOpBIALR}},
  \code{\link{pCOpBIALT}}, \code{\link{pCOpBIASC}},
  \code{\link{pCOpBIATW}}
}
