% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/401.p-Confidence_p-Bias_BASE_All.R
\name{pCOpBIEX}
\alias{pCOpBIEX}
\title{p-confidence and p-bias for  Exact method given n and alpha level}
\usage{
pCOpBIEX(n, alp, e)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{e}{- Exact method indicator  in [0, 1] {1: Clopper Pearson, 0.5: Mid P}.
The input can also be a range of values between 0 and 1.}
}
\value{
A dataframe with
 \item{x1}{  Number of successes (positive samples)}
 \item{pconf }{   p-Confidence}
 \item{pbias }{   p-Bias}
 \item{e }{- Exact method input}
}
\description{
p-confidence and p-bias for  Exact method given n and alpha level
}
\details{
Evaluation of Confidence interval for \code{p} based on inverting equal-tailed binomial tests with null hypothesis \eqn{H0: p = p0} using p-confidence and p-bias for the \eqn{n + 1} intervals
}
\examples{
n=5; alp=0.05;e=0.5
pCOpBIEX(n,alp,e)
n=5; alp=0.05;e=1 #Clopper-Pearson
pCOpBIEX(n,alp,e)
n=5; alp=0.05;e=c(0.1,0.5,0.95,1) #Range including Mid-p and Clopper-Pearson
pCOpBIEX(n,alp,e)
}
\references{
[1] 2005 Vos PW and Hudson S.
Evaluation Criteria for Discrete Confidence Intervals: Beyond Coverage and Length.
The American Statistician: 59; 137 - 142.
}
\seealso{
Other p-confidence and p-bias of base methods: \code{\link{PlotpCOpBIAS}},
  \code{\link{PlotpCOpBIAll}}, \code{\link{PlotpCOpBIBA}},
  \code{\link{PlotpCOpBIEX}}, \code{\link{PlotpCOpBILR}},
  \code{\link{PlotpCOpBILT}}, \code{\link{PlotpCOpBISC}},
  \code{\link{PlotpCOpBITW}}, \code{\link{PlotpCOpBIWD}},
  \code{\link{pCOpBIAS}}, \code{\link{pCOpBIAll}},
  \code{\link{pCOpBIBA}}, \code{\link{pCOpBILR}},
  \code{\link{pCOpBILT}}, \code{\link{pCOpBISC}},
  \code{\link{pCOpBITW}}, \code{\link{pCOpBIWD}}
}
